# 📜 Волга ИТ 2025 Автоматизация тестирования на Java

## 📦 Установка и запуск

### 1. Клонирование репозитория
```bash
git clone https://github.com/ktokar06/VolgaIT_2025.git
cd VolgaIT_2025
```

### 2. Запуск тестов
```bash
# Очистка и запуск всех тестов
mvn clean test

# Генерация и просмотр отчета Allure
mvn allure:report
mvn allure:serve

# Установка Allure (если требуется)
mvn allure:install -f pom.xml
```

## 🛠 Технологический стек
- **Java 17**
- **Selenium WebDriver 4.27.0**
- **TestNG 7.10.2**
- **Maven**
- **Allure Framework 2.30.0**
- **WebDriverManager 5.6.1**

---

## 🏗 Архитектура проекта

### Структура проекта
```
src/test/java/org/example/
├── config/
│   └── TimeoutConfig.java          # Конфигурация таймаутов
│   └── TaskSolver.java             # Конфигурация решений алгоритмический задача
├── pages/
│   ├── BasePage.java               # Базовый класс для Page Object
│   ├── FormFieldsPage.java         # Страница полей формы
│   ├── ClickEventsPage.java        # Страница событий клика
│   └── PopupsPage.java             # Страница модальных окон
│   └── RegistrationPage.java       # Страница регистрации пользователя
├── tests/
│   ├── BaseTest.java               # Базовый класс для тестов
│   ├── formfields/                 # Тесты для полей формы
│   │   ├── FormFieldsSmokeTest.java
│   │   ├── FormFieldsQualityTest.java
│   │   └── FormFieldsRegressionTest.java
│   ├── clickevents/                # Тесты для событий клика
│   │   ├── ClickEventsSmokeTest.java
│   │   ├── ClickEventsQualityTest.java
│   │   └── ClickEventsRegressionTest.java
│   └── popups/                     # Тесты для модальных окон
│       ├── PopupsSmokeTest.java
│       ├── PopupsQualityTest.java
│       └── PopupsRegressionTest.java
│   └── registration/                     # Тесты для регистрации пользователя
│       ├── RegistrationQualityTest.java
│       ├── RegistrationRegressionTest.java
│       └── RegistrationSmokeTest.java
└── utils/
    ├── WaitUtils.java              # Утилиты ожидания
    └── ParameterProvider.java      # Провайдер параметров

src/test/resources/
├── configuration/
│   └── config.properties           # Конфигурационные параметры
└── testng/
    └── testng.xml                  # Конфигурация TestNG
```

---

## 🧪 Тестовые сценарии

## 📋 FormFields Tests (Тестирование полей формы)

### **🔥 Smoke Tests**
**Класс:** `FormFieldsSmokeTest`

#### **Тест 1:** `testBasicFormFill`
- **Действия:**
    - Заполняет обязательные поля: имя, пароль
    - Выбирает желтый цвет
    - Отправляет форму
- **Проверка:** Появление алерта "Message received!"

#### **Тест 2:** `testFormWithDrinks`
- **Действия:**
    - Заполняет обязательные поля
    - Выбирает напитки: Milk и Coffee
    - Выбирает желтый цвет
    - Отправляет форму
- **Проверка:** Появление алерта "Message received!"

### **⚡ Quality Tests**
**Класс:** `FormFieldsQualityTest`

#### **Тест 1:** `testAutomationToolsList`
- **Действия:** Получает список инструментов автоматизации со страницы
- **Проверка:**
    - Список не пустой
    - Содержит минимум 3 инструмента
    - Содержит Selenium

#### **Тест 2:** `testFormSubmissionWithCompleteData`
- **Действия:**
    - Заполняет все поля формы полностью
    - Выбирает напитки Milk и Coffee
    - Выбирает автоматизацию "Yes"
    - Заполняет email
    - Заполняет сообщение списком инструментов
- **Проверка:** Успешная отправка формы

#### **Тест 3:** `testFormSubmissionWithMinimalData`
- **Действия:**
    - Заполняет только обязательные поля
    - Выбирает желтый цвет
- **Проверка:** Успешная отправка формы

### **🔄 Regression Tests**
**Класс:** `FormFieldsRegressionTest`

#### **Тест 1:** `testCompleteFormFill`
- **Действия:** Полное заполнение всех полей формы
- **Проверка:** Успешная отправка формы

#### **Тест 2:** `testMultipleSubmissions`
- **Действия:**
    - Отправляет форму первый раз
    - Перезагружает страницу
    - Отправляет форму второй раз с другими данными
- **Проверка:** Обе отправки успешны

---

## 🖱 ClickEvents Tests (Тестирование событий клика)

### **🔥 Smoke Tests**
**Класс:** `ClickEventsSmokeTest`

#### **Тест:** `testBasicButtonClicks`
- **Действия:**
    - Нажимает кнопки Cat и Dog
- **Проверка:**
    - После Cat отображается "Meow!"
    - После Dog отображается "Woof!"

### **⚡ Quality Tests**
**Класс:** `ClickEventsQualityTest`

#### **Тест 1:** `testMultipleSequentialClicks`
- **Действия:** Последовательно нажимает все кнопки животных
- **Проверка:** Отображается текст последнего клика ("Moo!")

#### **Тест 2:** `testMessageOrder`
- **Действия:** Нажимает кнопки в определенном порядке
- **Проверка:** Каждое сообщение соответствует правильной кнопке

### **🔄 Regression Tests**
**Класс:** `ClickEventsRegressionTest`

#### **Тест 1:** `testAllAnimalButtons`
- **Действия:** Нажимает все кнопки животных по порядку
- **Проверка:** Каждая кнопка отображает правильное сообщение

#### **Тест 2:** `testRepeatedClicksOnSameButton`
- **Действия:** Дважды нажимает кнопку Cat
- **Проверка:** Оба раза отображается "Meow!"

---

## 🪟 Popups Tests (Тестирование модальных окон)

### **🔥 Smoke Tests**
**Класс:** `PopupsSmokeTest`

#### **Тест 1:** `testBasicAlert`
- **Действия:** Нажимает кнопку Alert и принимает алерт
- **Проверка:** Успешная обработка алерта

#### **Тест 2:** `testBasicConfirm`
- **Действия:** Нажимает кнопку Confirm и принимает подтверждение
- **Проверка:** Текст результата содержит информацию о принятии

### **⚡ Quality Tests**
**Класс:** `PopupsQualityTest`

#### **Тест 1:** `testConfirmTextVariations`
- **Действия:**
    - Принимает подтверждение → проверяет текст "OK it is!"
    - Отклоняет подтверждение → проверяет текст "Cancel it is!"
- **Проверка:** Правильные тексты для разных действий

#### **Тест 2:** `testTooltipBehavior`
- **Действия:**
    - Проверяет, что тултип изначально не виден
    - Нажимает триггер тултипа
    - Проверяет видимость и текст тултипа
- **Проверка:**
    - Тултип скрыт изначально
    - После клика тултип виден
    - Текст тултипа "Cool text"

### **🔄 Regression Tests**
**Класс:** `PopupsRegressionTest`

#### **Тест 1:** `testAllPopupTypes`
- **Действия:** Полный цикл тестирования всех типов попапов:
    - Alert
    - Confirm (принятие и отмена)
    - Prompt (с текстом и отмена)
    - Tooltip
- **Проверка:** Все типы попапов работают корректно

#### **Тест 2:** `testPromptEdgeCases`
- **Действия:**
    - Пустой ввод с принятием
    - Длинный текст (100 символов)
- **Проверка:** Обработка граничных значений

---

## 👤 Registration Tests (Тестирование регистрации пользователя)

### **🔥 Smoke Tests**
**Класс:** `RegistrationSmokeTest`

#### **Тест 1:** `testSuccessfulRegistration`
- **Действия:**
    - Решает алгоритмические задачи
    - Заполняет все обязательные поля
    - Выбирает семейное положение "Single"
    - Выбирает хобби "Dance" и "Reading"
    - Заполняет дату рождения
    - Создает username и password
    - Отправляет форму
- **Проверка:** Форма успешно обрабатывается

#### **Тест 2:** `testRegistrationWithDifferentMaritalStatus`
- **Действия:**
    - Решает алгоритмические задачи
    - Заполняет данные для пользователя Anna Smith
    - Выбирает семейное положение "Married"
    - Выбирает хобби "Cricket"
    - Заполняет все остальные поля
    - Отправляет форму
- **Проверка:** Форма успешно обрабатывается

### **⚡ Quality Tests**
**Класс:** `RegistrationQualityTest`

#### **Тест:** `testFormValidation`
- **Действия:** Пытается отправить пустую форму
- **Проверка:** Форма не должна отправляться без заполнения обязательных полей

### **🔄 Regression Tests**
**Класс:** `RegistrationRegressionTest`

#### **Тест:** `testFormElementsStates`
- **Действия:**
    - Выбирает семейное положение "Single" → проверяет выбор
    - Выбирает хобби "Dance" → проверяет выбор
    - Снимает выбор хобби "Dance" → проверяет снятие
    - Выбирает семейное положение "Married" → проверяет выбор и снятие предыдущего
- **Проверка:** Корректная работа переключателей и чекбоксов

---

## 🎯 Ключевые особенности реализации

### **📐 Паттерны проектирования**
- **Page Object Model** - разделение логики страниц и тестов
- **Page Factory** - инициализация элементов страницы
- **Singleton** - для ParameterProvider
- **Fluent Interface** - цепочки вызовов методов

### **🔄 Управление ожиданиями**
- Явные ожидания через `WebDriverWait`
- Конфигурируемые таймауты в `TimeoutConfig`
- Специализированные методы в `WaitUtils`

### **📊 Allure отчетность**
- Детальные шаги тестов с аннотацией `@Step`
- Группировка тестов по Epic/Feature/Story
- Приоритеты тестов (`@Severity`)
- Автоматические скриншоты при ошибках

### **⚙️ Конфигурация**
- Централизованное управление параметрами через `ParameterProvider`
- Поддержка разных браузеров (Chrome, Firefox)
- Гибкая настройка через properties-файлы

### **🧩 Алгоритмические задачи**
- Автоматическое решение математических задач в форме регистрации
- Интеграция результатов в процесс заполнения формы